package com.example.sefinsa_app.ui.avales.documentos;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.MemoryPolicy;
import com.squareup.picasso.NetworkPolicy;
import com.squareup.picasso.Picasso;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AvalesDocumentosFragment extends Fragment {

    private AvalesDocumentosViewModel mViewModel;
    private TextView tvAval;
    private Aval aval;
    private String avalId;
    private LinearLayoutCompat comprobantesAval, garantiasAval;
    private VolleyS vs;
    private RequestQueue requestQueue;

    public static AvalesDocumentosFragment newInstance() {
        return new AvalesDocumentosFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        return inflater.inflate(R.layout.fragment_avales_documentos, container, false);

    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                getFiles("comprobantes/avales/"+aval.getId()+"_"+aval.getNombre_completo().toUpperCase(),comprobantesAval);
                getFiles("garantias/avales/"+aval.getId()+"_"+aval.getNombre_completo().toUpperCase(),garantiasAval);
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initElements(view);

        getFiles("comprobantes/avales/"+aval.getId()+"_"+aval.getNombre_completo().toUpperCase().toUpperCase(),comprobantesAval);
        getFiles("garantias/avales/"+aval.getId()+"_"+aval.getNombre_completo().toUpperCase().toUpperCase(),garantiasAval);
        Log.d("DEBUG1", String.valueOf(aval));
        Log.d("DEBUG2", avalId);
    }

    public void initElements(View view){

        CurrentFragment.fragment = "AvalesDocumentosFragment";

        Bundle args = getArguments();
        String personJsonString = args.getString("aval");
        String personJsonString3 = args.getString("avalId");
        aval = Utils.getGsonParser().fromJson(personJsonString, Aval.class);

        avalId = personJsonString3;
        tvAval = view.findViewById(R.id.tvAval);
        tvAval.setText("AVAL: \n" + aval.getNombre_completo());

        comprobantesAval = view.findViewById(R.id.comprobantesAval);
        garantiasAval = view.findViewById(R.id.garantiasAval);
    }

    public void getFiles(String carpeta, LinearLayoutCompat contenedor) {
        ArrayList<String> CAE = new ArrayList<>();
        ArrayList<String> GAE = new ArrayList<>();
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        Log.d("archivos", "Entro a getFiles AVALES:.................");
        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        String path = API.url.replace("php/", "resources/");
        //String path = "https://sw.gruposefinsa.com/resources/";
        //String path = "https://gruposefinsa.com/test/resources/";
        String ruta2 = "../../resources/" + carpeta;
        String ruta = "../../resources/" + carpeta + "/9Expediente";
        Log.d("ruta", "RUTA:..........."+ ruta);
        Log.d("ruta", "LIGA COMPLETA:..........."+ carpeta);
        JSONObject data = new JSONObject();
        try {
            data.put("func", "archivos");
            data.put("ruta", ruta);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        Log.d("ruta", "LIGA COMPLETA EN DATA:..........."+ data);
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            dialog.cancel();
                            Log.d("data", String.valueOf(data));
                            Log.d("response11", "onResponse: " + response);

                            if (!response.get("data").toString().equals("false")) {
                                JSONArray jsonArray = (JSONArray) response.get("data");
                                Log.d("archivos", jsonArray.length() + "");

                                // Crear una lista para almacenar los nombres de archivo
                                List<String> fileNames = new ArrayList<>();

                                for (int i = 2; i < jsonArray.length(); i++) {
                                    if (jsonArray.getString(i).matches("[0-4]CAE\\.jpeg")) {
                                        CAE.add(jsonArray.getString(i));
                                    } else if (jsonArray.getString(i).matches("[0-3]GAE\\.jpeg")) {
                                        GAE.add(jsonArray.getString(i));
                                    } else if (jsonArray.getString(i).matches("[0-6]CCE\\.jpeg")){
                                        fileNames.add(jsonArray.getString(i));
                                    }
                                }

                                Boolean r = false;
                                if (!CAE.isEmpty()) {
                                    showImageSequentially2(CAE, 0, path, comprobantesAval , carpeta);
                                    r = true;
                                }
                                if (!GAE.isEmpty()) {
                                    showImageSequentially2(GAE, 0, path, garantiasAval , carpeta);
                                    r = true;
                                }
                                if (r) {
                                    return;
                                } else {
                                    // Ordenar la lista de nombres de archivo
                                    Collections.sort(fileNames, new Comparator<String>() {
                                        @Override
                                        public int compare(String o1, String o2) {
                                            // Extraer el número completo desde el inicio del nombre de archivo
                                            return Integer.compare(extractLeadingNumber(o1), extractLeadingNumber(o2));
                                        }

                                        // Método para extraer el número completo desde el inicio del nombre de archivo
                                        private int extractLeadingNumber(String fileName) {
                                            StringBuilder number = new StringBuilder();
                                            for (char c : fileName.toCharArray()) {
                                                if (Character.isDigit(c)) {
                                                    number.append(c);  // Agregar cada dígito al número
                                                } else {
                                                    break;  // Salir cuando no sea un dígito
                                                }
                                            }
                                            return Integer.parseInt(number.toString());
                                        }
                                    });
                                    if (GAE.isEmpty() && CAE.isEmpty()) {
                                        showImageSequentially2(fileNames, 0, path, contenedor , carpeta);
                                    }
                                }
                            } else {
                                JSONObject data2 = new JSONObject();
                                try {
                                    data2.put("func", "archivos");
                                    data2.put("ruta", ruta2);
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }

                                JsonObjectRequest request2 = new JsonObjectRequest(Request.Method.POST, API.urlAvales, data2,
                                        new Response.Listener<JSONObject>() {

                                            @Override
                                            public void onResponse(JSONObject response) {
                                                try {
                                                    dialog.cancel();
                                                    Log.d("data2", String.valueOf(data2));
                                                    Log.d("response2", "onResponse: " + response);

                                                    if (!response.get("data").toString().equals("false")) {
                                                        JSONArray jsonArray = (JSONArray) response.get("data");
                                                        Log.d("archivos", jsonArray.length() + "");

                                                        if (jsonArray.length() >= 4) {
                                                            // Crear una lista para almacenar los nombres de archivo
                                                            List<String> fileNames = new ArrayList<>();

                                                            for (int i = 2; i < jsonArray.length(); i++) {
                                                                fileNames.add(jsonArray.getString(i));
                                                            }

                                                            // Ordenar la lista de nombres de archivo
                                                            Collections.sort(fileNames, new Comparator<String>() {
                                                                @Override
                                                                public int compare(String o1, String o2) {
                                                                    // Extraer el número completo desde el inicio del nombre de archivo
                                                                    return Integer.compare(extractLeadingNumber(o1), extractLeadingNumber(o2));
                                                                }

                                                                // Método para extraer el número completo desde el inicio del nombre de archivo
                                                                private int extractLeadingNumber(String fileName) {
                                                                    StringBuilder number = new StringBuilder();
                                                                    for (char c : fileName.toCharArray()) {
                                                                        if (Character.isDigit(c)) {
                                                                            number.append(c);  // Agregar cada dígito al número
                                                                        } else {
                                                                            break;  // Salir cuando no sea un dígito
                                                                        }
                                                                    }
                                                                    return Integer.parseInt(number.toString());
                                                                }
                                                            });

                                                            // Mostrar imágenes una por una
                                                            Log.d("fileNames", "onResponse: " + fileNames);
                                                            Log.d("path", "onResponse: " + path);
                                                            Log.d("carpeta", "onResponse: " + carpeta);
                                                            Log.d("contenedor", "onResponse: " + contenedor);
                                                            showImageSequentially(fileNames, 0, path, contenedor , carpeta);
                                                        } else {
                                                            DatabaseHelper dbh = new DatabaseHelper(getContext());
                                                            SQLiteDatabase db = dbh.getReadableDatabase();
                                                            String query = "SELECT * FROM clientes WHERE aval_id = ?";
                                                            Cursor cursor = db.rawQuery(query, new String[]{avalId});

                                                            String cc = "";
                                                            String cg = "";
                                                            if (cursor.moveToFirst()) {
                                                                cc = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_comprobantes"));
                                                                cg = cursor.getString(cursor.getColumnIndexOrThrow("carpeta_garantias"));
                                                                getFiles("comprobantes/clientes/" + cc, comprobantesAval);
                                                            }

                                                            return;
                                                        }


                                                    }
                                                } catch (JSONException e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }, new Response.ErrorListener() {
                                    @Override
                                    public void onErrorResponse(VolleyError error) {
                                        dialog.cancel();
                                        ErrorChecker.checker(error, getActivity());
                                    }
                                });
                                request2.setRetryPolicy(new DefaultRetryPolicy(
                                        30000,
                                        DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                                        DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

                                request2.setShouldCache(false);
                                requestQueue.add(request2);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void showImageSequentially(List<String> fileNames, int index, String path, LinearLayoutCompat contenedor, String carpeta) {
        if (index >= fileNames.size()) return;  // Salir si se ha mostrado todas las imágenes

        Context context = getContext();
        if (context == null) {
            return;
        }

        DisplayMetrics displayMetrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;

        // Define el porcentaje deseado (por ejemplo, 85%)
        float percentage = 0.85f;
        int calculatedWidth = (int) (windowWidth * percentage);
        String fileName = fileNames.get(index);
        Log.d("FILE", fileName);

        // Extraer los primeros tres caracteres para verificar tipo
        String prefix = fileName.substring(0, 3);  // Ejemplo: "0CA", "1GA"

        // Mapa para los títulos de los comprobantes (CA)
        Map<Integer, String> comprobanteTitleMap = new HashMap<>();
        comprobanteTitleMap.put(0, "INE FRENTE");
        comprobanteTitleMap.put(1, "INE REVERSE");
        comprobanteTitleMap.put(2, "COMPROBANTE");
        comprobanteTitleMap.put(3, "FOTO");
        comprobanteTitleMap.put(4, "FACHADA");

        // Título genérico para garantías (GA)
        String garantiaTitle = "GARANTIA";

        // Extraer el primer dígito para usarlo como índice en el mapa
        int fileType;
        try {
            fileType = Integer.parseInt(fileName.substring(0, 1)); // Extrae el primer carácter como número
        } catch (NumberFormatException e) {
            Log.e("Error", "No se pudo extraer el número del archivo: " + fileName);
            return;  // Si no es un número válido, omitir este archivo
        }

        String title;

        // Verificar si es un comprobante (termina en CA) o garantía (termina en GA)
        if (prefix.endsWith("CA")) {
            title = comprobanteTitleMap.containsKey(fileType) ? comprobanteTitleMap.get(fileType) : "TÍTULO DESCONOCIDO";
        } else if (prefix.endsWith("GA")) {
            title = garantiaTitle;
        } else {
            Log.e("Error", "Archivo no reconocido: " + fileName);
            return;  // Si no coincide con CA o GA, omitir este archivo
        }

        // Crear el ImageView
        ImageView image = new ImageView(getActivity());

        String imageUrl = path + carpeta + "/" + fileName;

        // Usa Glide para obtener las dimensiones de la imagen y ajustar el tamaño del ImageView
        Glide.with(getActivity())
                .asBitmap()
                .load(imageUrl)
                .diskCacheStrategy(DiskCacheStrategy.NONE)  // Desactiva la caché de disco
                .skipMemoryCache(true)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                        // Obtén las dimensiones de la imagen
                        int imageWidth = resource.getWidth();
                        int imageHeight = resource.getHeight();

                        // Calcula el alto basado en la relación de aspecto
                        int calculatedHeight = (int) ((float) imageHeight / imageWidth * calculatedWidth);

                        // Configura los LayoutParams del ImageView
                        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(
                                calculatedWidth,  // Ancho calculado como porcentaje del ancho de la ventana
                                calculatedHeight  // Alto calculado manteniendo la relación de aspecto
                        );
                        params.setMargins(0, 0, 0, 15);

                        image.setLayoutParams(params);
                        image.setScaleType(ImageView.ScaleType.FIT_CENTER); // Ajustar la imagen dentro del ImageView sin recortes

                        // Establece la imagen en el ImageView
                        image.setImageBitmap(resource);

                        Context context = getContext();
                        if (context == null) {
                            return;
                        }

                        // Crea el TextView para el título
                        TextView titleTextView = new TextView(getActivity());
                        titleTextView.setText(title);
                        titleTextView.setTextSize(16); // Ajusta el tamaño de fuente
                        titleTextView.setLayoutParams(new LinearLayoutCompat.LayoutParams(
                                LinearLayoutCompat.LayoutParams.WRAP_CONTENT,
                                LinearLayoutCompat.LayoutParams.WRAP_CONTENT
                        ));
                        titleTextView.setPadding(0, 0, 0, 5); // Margen inferior

                        // Añade el TextView y el ImageView al contenedor
                        contenedor.addView(titleTextView); // Agregar el TextView primero
                        contenedor.addView(image); // Luego agregar la imagen

                        // Configura el onClickListener para mostrar la imagen en un dialogo
                        image.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View view) {
                                View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_documento, null);
                                TouchImageView touchImageView = dialogView.findViewById(R.id.imagen);
                                Picasso.get()
                                        .load(imageUrl)
                                        .memoryPolicy(MemoryPolicy.NO_CACHE, MemoryPolicy.NO_STORE)
                                        .networkPolicy(NetworkPolicy.NO_CACHE)
                                        .into(touchImageView);

                                new MaterialAlertDialogBuilder(getActivity())
                                        .setTitle("")
                                        .setView(dialogView)
                                        .setCancelable(false)
                                        .setPositiveButton("CERRAR", new DialogInterface.OnClickListener() {
                                            @Override
                                            public void onClick(DialogInterface dialogInterface, int i) {
                                                // No hacer nada aquí, simplemente cerrar el diálogo
                                            }
                                        })
                                        .show();
                            }
                        });

                        // Cargar la siguiente imagen después de un pequeño retraso
                        new Handler(Looper.getMainLooper()).postDelayed(() -> showImageSequentially(fileNames, index + 1, path, contenedor, carpeta), 1000); // Retraso de 1 segundo
                    }
                });
    }

    // Declaración global en tu clase (fuera de la función)
    private final Set<String> showingSets = new HashSet<>();

    private void showImageSequentially2(List<String> fileNames, int index, String path, LinearLayoutCompat contenedor, String carpeta) {
        // Clave única para evitar ejecuciones duplicadas
        String key = path + carpeta + contenedor.hashCode();

        Context context = getContext();
        if (context == null) {
            showingSets.remove(key);
            return;
        }

        // Si estamos en la primera llamada, verificar si ya se está mostrando esta secuencia
        if (index == 0) {
            if (showingSets.contains(key)) {
                Log.d("DEBUG", "Ya se está mostrando esta secuencia: " + key);
                return;
            } else {
                showingSets.add(key);
            }
        }

        // Salir si hemos llegado al final
        if (index >= fileNames.size()) {
            showingSets.remove(key); // Liberar el control
            return;
        }

        DisplayMetrics displayMetrics = new DisplayMetrics();
        getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int windowWidth = displayMetrics.widthPixels;

        float percentage = 0.85f;
        int calculatedWidth = (int) (windowWidth * percentage);
        String fileName = fileNames.get(index);
        Log.d("FILE", fileName);

        String prefix = fileName.substring(0, 3);

        Map<Integer, String> comprobanteTitleMap = new HashMap<>();
        comprobanteTitleMap.put(0, "INE FRENTE");
        comprobanteTitleMap.put(1, "INE REVERSE");
        comprobanteTitleMap.put(2, "COMPROBANTE");
        comprobanteTitleMap.put(3, "FOTO");
        comprobanteTitleMap.put(4, "FACHADA");

        String garantiaTitle = "GARANTIA";

        int fileType;
        try {
            fileType = Integer.parseInt(fileName.substring(0, 1));
        } catch (NumberFormatException e) {
            Log.e("Error", "No se pudo extraer el número del archivo: " + fileName);
            showingSets.remove(key);
            return;
        }

        String title;
        if (prefix.endsWith("CA")) {
            title = comprobanteTitleMap.getOrDefault(fileType, "TÍTULO DESCONOCIDO");
        } else if (prefix.endsWith("GA")) {
            title = garantiaTitle;
        } else {
            Log.e("Error", "Archivo no reconocido: " + fileName);
            showingSets.remove(key);
            return;
        }

        ImageView image = new ImageView(getActivity());
        String imageUrl = path + carpeta + "/9Expediente/" + fileName;

        Glide.with(getActivity())
                .asBitmap()
                .load(imageUrl)
                .diskCacheStrategy(DiskCacheStrategy.NONE)
                .skipMemoryCache(true)
                .into(new SimpleTarget<Bitmap>() {
                    @Override
                    public void onResourceReady(Bitmap resource, Transition<? super Bitmap> transition) {
                        int imageWidth = resource.getWidth();
                        int imageHeight = resource.getHeight();
                        int calculatedHeight = (int) ((float) imageHeight / imageWidth * calculatedWidth);

                        LinearLayoutCompat.LayoutParams params = new LinearLayoutCompat.LayoutParams(
                                calculatedWidth, calculatedHeight);
                        params.setMargins(0, 0, 0, 15);
                        image.setLayoutParams(params);
                        image.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        image.setImageBitmap(resource);

                        Context context = getContext();
                        if (context == null) {
                            Log.e("ERROR", "Contexto es null, se aborta la carga de la imagen: " + fileName);
                            showingSets.remove(key);
                            return;
                        }

                        TextView titleTextView = new TextView(context);
                        titleTextView.setText(title);
                        titleTextView.setTextSize(16);
                        titleTextView.setLayoutParams(new LinearLayoutCompat.LayoutParams(
                                LinearLayoutCompat.LayoutParams.WRAP_CONTENT,
                                LinearLayoutCompat.LayoutParams.WRAP_CONTENT));
                        titleTextView.setPadding(0, 0, 0, 5);

                        contenedor.addView(titleTextView);
                        contenedor.addView(image);


                        image.setOnClickListener(view -> {
                            View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_documento, null);
                            TouchImageView touchImageView = dialogView.findViewById(R.id.imagen);
                            Picasso.get()
                                    .load(imageUrl)
                                    .memoryPolicy(MemoryPolicy.NO_CACHE, MemoryPolicy.NO_STORE)
                                    .networkPolicy(NetworkPolicy.NO_CACHE)
                                    .into(touchImageView);

                            new MaterialAlertDialogBuilder(getActivity())
                                    .setTitle("")
                                    .setView(dialogView)
                                    .setCancelable(false)
                                    .setPositiveButton("CERRAR", (dialogInterface, i) -> {})
                                    .show();
                        });

                        new Handler(Looper.getMainLooper()).postDelayed(() -> {
                            showImageSequentially2(fileNames, index + 1, path, contenedor, carpeta);
                        }, 100);
                    }
                });
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(AvalesDocumentosViewModel.class);
        // TODO: Use the ViewModel
    }

}